#include <stdio.h>
#include <unistd.h>

#include "../hubolib.h"
#include "../hubocfg.h" // Required for changing default I2C device.

using namespace HuboLib;

/*
Compile and link: 
	g++ LoadTest.cpp -L../ -lhubo -lpthread -lrt -o LoadTest.out
Run:
	sudo ./LoadTest.out
Purpose:
	Lets turn on all relais, and go into an infinite loop to have the CPU consume as much power as possible. 
*/

int main(int argc, char* argv[])
{
	if (argc != 2)
	{
		printf ("Usage: \n  LoadTest.out <digital outputs to activate>\n  example: LoadTest.out 5  // this will set channels 0 and 2\n");
		return 1;
	}
	
	int outValue = 0;
	if (sscanf (argv[1], "%d", &outValue) != 1)
	{
		printf ("Digital output could not be determined!\n");
		return 1;
	}

	printf ("Setting digital outputs to 0x%02X.\n", outValue);
	printf ("Hit Ctrl+C to terminate.\n");
	
	// If required - set the I2C device to work with. The Raspberry Pi uses "/dev/i2c-1" which is default, the Banana Pi uses "/dev/i2c-0"
	#ifdef BPI
	    g_I2CConfig.m_sI2CDevice = "/dev/i2c-0";
	#endif
	
	// Initialize the library once in your program.
	if (!Initialize())
	{
		printf ("Error: Initialize\n");
		return 1;
	}
	
	// Set the cycle time to 2ms (500Hz).
	Set_Cycle_Time(2);
	
	// Finally set the output.
	Set_DO_Channels (outValue);

	// Press Ctrl-C to stop.
	while (1);
	
	// Free library resources.
	Uninitialize();
	
	return 0;
}
