#include <stdio.h>
#include <unistd.h>
#include "../hubolib.h"

using namespace HuboLib;

/*
Compile and link: 
	g++ MCP970x.cpp -L../ -lhubo -lpthread -lrt -o MCP970x.out
Run:
	sudo ./MCP970x.out
Purpose:
	Simple usage of an MCP9700 and MCP9701 temperature sensor.
*/

int main(void)
{
/*
	double volt;
	printf ("Some voltages and their corresponding temperatures.\n");
	volt = 0.0;
	printf ("Voltage=%lf Associated temperatures: MCP9701=%lfC MCP9700=%lfC\n", volt, Get_MCP7901_Temperature(volt), Get_MCP7900_Temperature(volt));
	volt = 0.4;
	printf ("Voltage=%lf Associated temperatures: MCP9701=%lfC MCP9700=%lfC\n", volt, Get_MCP7901_Temperature(volt), Get_MCP7900_Temperature(volt));
	volt = 0.5;
	printf ("Voltage=%lf Associated temperatures: MCP9701=%lfC MCP9700=%lfC\n", volt, Get_MCP7901_Temperature(volt), Get_MCP7900_Temperature(volt));
	volt = 1.0;
	printf ("Voltage=%lf Associated temperatures: MCP9701=%lfC MCP9700=%lfC\n", volt, Get_MCP7901_Temperature(volt), Get_MCP7900_Temperature(volt));
	volt = 2.0;
	printf ("Voltage=%lf Associated temperatures: MCP9701=%lfC MCP9700=%lfC\n", volt, Get_MCP7901_Temperature(volt), Get_MCP7900_Temperature(volt));
*/
	// Initialize the library once in your program.
	if (!Initialize())
	{
		printf ("Error: Initialize\n");
		return 1;
	}

	// Retrieving the reference voltage requires the library to be initialized.
	double volt = Get_VRef();
//	printf ("Voltage=%lf Associated temperatures: MCP9701=%lfC MCP9700=%lfC\n", volt, Get_MCP7901_Temperature(volt), Get_MCP7900_Temperature(volt));
	
	// We'll use channel 0 for testing.
	unsigned short overSampling[MAX_MCP3x08_CHANNELS] = { 1, 1, 0, 0, 0, 0, 0, 0 };
	Set_MCP3x08_Oversampling (overSampling);

	// Wait until the ADC buffers are filled.
	usleep(10000);
	double volt2;
	unsigned long 	adcCount, adcCount2; 

	while (1)
	{
		Get_AI_Channel (0, adcCount, volt);   // Connect to MCP9700.
		Get_AI_Channel (1, adcCount2, volt2); // Connect to MCP9701.
		printf ("Associated temperatures: MCP9700=%lfC MCP9701=%lfC\n", Get_MCP9700_Temperature(volt), Get_MCP9701_Temperature(volt2));
		usleep(1000000);
	}
	// Free library resources.
	Uninitialize();
	
	return 0;
}
