#!/usr/bin/python

import spidev
import time

# Hubo MCP3208 Demo - simple reading of the MCP3208 analog input.

def Open_SPI_ADC ():
    spiADC = spidev.SpiDev()
    spiADC.open(0, 0)
    spiADC.max_speed_hz = (50000)
    return spiADC
	
def Get_AI_Channel (spiADC, channel):
    if ((channel > 7) or (channel < 0)):
        print 'Illegal channel number (0 through 7)'
        return 0.0
    result = spiADC.xfer2([6 + (channel >> 2), channel << 6, 0])
    count = ((result[1] & 0x0F) << 8) + (result[2])
    # Use a reference voltage of 2.53V.
    voltage = (2.53 * count) / 4096
    return voltage
	
# Read 10 values from analog input 0.
spiADC = Open_SPI_ADC()
for i in range(0, 9):
    print Get_AI_Channel (spiADC, 0)
    time.sleep(1)
spiADC.close();
