#include <stdio.h>
#include <vector>

#include "../hubolib.h"
#include "../hubocfg.h" // Required for changing default I2C device.

using namespace std;

using namespace HuboLib;

/*
Compile and link: 
	g++ DigitalSlaveList.cpp -L../ -lhubo -lpthread -lrt -o DigitalSlaveList.out
Run:
	sudo ./DigitalSlaveList.out
Purpose:
	Print out a list of all digital slaves found on the I2C bus.
*/

int main(void)
{
	// If required - set the I2C device to work with. The Raspberry Pi uses "/dev/i2c-1" which is default, the Banana Pi uses "/dev/i2c-0"
	#ifdef BPI
	    g_I2CConfig.m_sI2CDevice = "/dev/i2c-0";
	#endif

	// We need to initialize the library prior to a call to GetSlaveDeviceList().
	vector<int> slaveAddressList;
	if (!GetSlaveDeviceList (slaveAddressList))
		printf ("No slaves found - call Initialize() first.\n");

	// Initialize the library once in your program.
	Initialize();
	
	if (GetSlaveDeviceList (slaveAddressList))
	{
		for (unsigned int i=0; i<slaveAddressList.size(); i++)
			printf ("Found slave address 0x%02X.\n", slaveAddressList[i]);
	}
	else
		printf ("No slaves found - call Initialize() first.\n");
	
	// Free library resources.
	Uninitialize();
	
	return 0;
}
