#include <stdio.h>
#include <unistd.h>

#include "../hubolib.h"

using namespace std;

using namespace HuboLib;

/*
Compile and link: 
	g++ DS18x20.cpp -L../ -lhubo -lpthread -lrt -o DS18x20.out
Run:
	./DS18x20.out
Purpose:
	This demo shows how to list all 1wire devices, how to check whether a devixe is of the
	type of a DS18S20 or DS18B20 sensor and how to read the data from the sensor.
	It does not require further initialization.
*/

void PrintTemperatureInfo	(vector <string>& devList);

int main(void)
{
	vector <string> devList;

	printf ("DS18x20 demo. Press Stg-C to exit.\n");

	while (1)
	{
		Get_1w_Devices(devList);
		PrintTemperatureInfo(devList);
		usleep (1000L * 10L);
	}
	return 0;
}


void PrintTemperatureInfo	(vector <string>& devList)
{
	double 	temperature;
	bool 	bCRC;
	long 	t_duration_ms;

	// For each device in the list...
	for (int i=0; i<devList.size(); i++)
	{
		// ... print the device ID...
		printf ("%02d. %s:  ", i+1, devList[i].c_str());
		
		// ... and if it's a DS18x20 temperature sensor...
		if (Is_DS18x20_Devices(devList[i].c_str()))
		{
			// ... retrieve the data.
			bool bResult = Get_DS18x20_Temperature (devList[i].c_str(), temperature, bCRC, t_duration_ms);
			printf ("Result=%s ", bResult?"true":"false");
			printf ("bCRC=%s ", bCRC?"true":"false");
			printf ("temp=%lf duration=%ld\n", temperature, t_duration_ms);
		}
		else
			printf ("\n");
	}
}