#include <stdio.h>
#include <unistd.h>

#include "../hubolib.h"
#include "../hubocfg.h" // Required for changing default I2C device.

using namespace HuboLib;

/*
Compile and link: 
	g++ DigitalInput2.cpp -L../ -lhubo -lpthread -lrt -o DigitalInput2.out
Run:
	sudo ./DigitalInput2.out
Purpose:
	Read digital inputs 0 and 1 and display them in the console.
	The program will terminate when digital input 2 is lowered to ground.
	The hubo library gets properly de-initialized prior to finishing.
*/

int main(void)
{
	// If required - set the I2C device to work with. The Raspberry Pi uses "/dev/i2c-1" which is default, the Banana Pi uses "/dev/i2c-0"
	#ifdef BPI
	    g_I2CConfig.m_sI2CDevice = "/dev/i2c-0";
	#endif

	// Initialize the library once in your program.
	Initialize();
	
	while (1) 
	{
		bool bState = false;
			
		// Read digital input number 0.
		Get_DI_Channel(0, bState);
		printf ("Digital input 0 = %s  ", bState ? "ON " : "OFF");
			
		// Read digital input number 1.
		Get_DI_Channel(1, bState);
		printf ("Digital input 1 = %s  \n", bState ? "ON " : "OFF");
		
		usleep (1000L * 10L);

		// Should we finish?
		Get_DI_Channel(2, bState);
		if (bState == false)
			break;
	} 

	// Free library resources.
	Uninitialize();
	
	return 0;
}
