#ifndef HUBOCFG_H
	#define HUBOCFG_H


#ifndef MAX_MCP23017_SLAVES
	#define MAX_MCP23017_SLAVES (7)
#endif


namespace HuboLib
{
	/**
	@defgroup Configuration Configuring and adapting to the hardware
	*/

	/**
	 * @brief Use to configure SPI specific parameters. 
	 * @param m_pMCP3x08Device Use to specify the SPI device and chip select e.g. "/dev/spidev0.1" for CS1.
	 * @see Initialize()
	 * @note Changes to the configuration must be made prior to a call to Initialize().
	 * @ingroup Configuration
	*/
	class SPI_Config
	{
		public:
			SPI_Config();
		
			char* m_pMCP3x08Device; // e.g. "/dev/spidev0.1" for choosing CS1
	};
	extern SPI_Config g_SPIConfig;


	/**
	 * @brief Use to configure I2C specific parameters. 
	 * @param m_MCP23017DeviceAddress Use to specify the I2C address e.g. 0x20.
	 * @see Initialize()
	 * @note Changes to the configuration must be made prior to a call to Initialize().
	 * @ingroup Configuration
	*/
	class I2C_Config
	{
		public:
			I2C_Config();
		
			unsigned char	m_MCP23017DeviceAddress;								// e.g. 0x20
			unsigned char	m_MCP23017SlaveDeviceAddressList[MAX_MCP23017_SLAVES];	// The list of I2C addresses to check for I2C slaves e.g. 0x21, 0x22 ...
			unsigned short  m_MCP23017SlaveCycleTickDivider;						// e.g. 1 for each call (default), 2 for every 2nd call 3 for every 3rd call...
			const char*		m_sI2CDevice;											// Raspberry Pi uses "/dev/i2c-1", Banana Pi uses "/dev/i2c-0"
	};
	extern I2C_Config g_I2CConfig;


	/**
	 * @brief Use to configure 1wire specific parameters. 
	 * @param m_pW1DeviceRootPath Use to specify the root path to the 1wire devices e.g. "/sys/bus/w1/devices".
	 * @see Initialize()
	 * @ingroup Configuration
	*/
	class W1_Config
	{
		public:
			W1_Config();
		
			char* m_pW1DeviceRootPath; // e.g. "/sys/bus/w1/devices"
	};
	extern W1_Config g_W1Config;

} // namespace HuboLib


namespace BCM2835
{
	/**
	 * @brief Use to configure BCM2835 specific parameters. 
	 * @param m_bUseMutexProtection If set to true then all access to BCM2835 functions are protected by a mutex. 
	 * This is also the default value when starting up the library. However, when the internal mutex is bypassed
	 * then read and write operations to the GPIO's more than double. 
	 * @see See BCM2835_GPIO and the demo GPIOInputOutput.cpp for more information.
	 * @ingroup BCM2835_GPIO
	*/
	class BCM2835_Config
	{
		public:
			BCM2835_Config();
		
			bool m_bUseMutexProtection; // If set to true then all access to BCM2835 functions are protected by a mutex.
	};
	extern BCM2835_Config g_bcm2835Config;

} // namespace BCM2835

#endif // HUBOCFG_H

