#include <stdio.h>
#include <unistd.h>

#include "../hubolib.h"
#include "../hubocfg.h" // Required for changing default I2C device.

using namespace HuboLib;

/*
Compile and link: 
	g++ DigitalSlaveInput1.cpp -L../ -lhubo -lpthread -lrt -o DigitalSlaveInput1.out
Run:
	sudo ./DigitalSlaveInput1.out
Purpose:
	Read digital inputs 0 and 1 from the I2C slave with index 0 (0x21) and display them in the console.
	The program will not terminate. Press Ctr-C to exit.
*/

int main(void)
{
	// If required - set the I2C device to work with. The Raspberry Pi uses "/dev/i2c-1" which is default, the Banana Pi uses "/dev/i2c-0"
	#ifdef BPI
	    g_I2CConfig.m_sI2CDevice = "/dev/i2c-0";
	#endif

	// Initialize the library once in your program.
	Initialize();
	
	while (1) 
	{
		bool bState = false;
			
		int slaveNo = 0;
		
		// Read digital input number 0.
		Get_Slave_DI_Channel(slaveNo, 0, bState);
		printf ("Slave %d - digital input 0 = %s  ", slaveNo, bState ? "ON " : "OFF");
			
		// Read digital input number 1.
		Get_Slave_DI_Channel(slaveNo, 1, bState);
		printf ("Slave %d - digital input 1 = %s  \n", slaveNo, bState ? "ON " : "OFF");
		
		usleep (1000L * 10L);
	} 

	// We won't get here - press Ctrl-C to terminate.
	return 0;
}

