#include <stdio.h>
#include <unistd.h>

#include "../hubolib.h"
#include "../hubocfg.h" // Required for changing default I2C device.

using namespace HuboLib;

/*
Compile and link: 
	g++ DigitalSlaveInput2.cpp -L../ -lhubo -lpthread -lrt -o DigitalSlaveInput2.out
Run:
	sudo ./DigitalSlaveInput2.out
Purpose:
	Read all digital inputs of I2cSlave 0 (0x21) in one go.
	The program will terminate when digital input 2 is lowered to ground.
*/

int main(void)
{
	// If required - set the I2C device to work with. The Raspberry Pi uses "/dev/i2c-1" which is default, the Banana Pi uses "/dev/i2c-0"
	#ifdef BPI
	    g_I2CConfig.m_sI2CDevice = "/dev/i2c-0";
	#endif

	// Initialize the library once in your program.
	if (!Initialize())
	{
		printf ("Error: Initialize\n");
		return 1;
	}
	
	int slaveNo = 0;
	unsigned char allInputs = 0;
	
	while (1) 
	{
		// Read all 8 digital inputs.
		Get_Slave_DI_Channels(slaveNo, allInputs);
		printf ("Slave %d - digital inputs (hex) = 0x%02X\n", slaveNo, allInputs);
		
		// Break if input 2 is lowered.
		if (~allInputs & 4)
			break;

		usleep (1000L * 10L);

	} 

	// Free library resources.
	Uninitialize();
	
	return 0;
}
