#!/usr/bin/python

import smbus
import time

# Hubo MCP23017 Demo - simple reading and writing of the MCP23017 digital IO.

IODIRA = 0x00
IODIRB = 0x01
GPPUB  = 0x0D
GPIOA  = 0x12
GPIOB  = 0x13

global g_ioaddress
g_ioaddress = 0x20  # I2C address - Hubo master modules use 0x20

def Initialize_MCP23017 ():
    i2cbus = smbus.SMBus(0)                            # Use 1 for the model B variants, use 0 for Banana Pi.
    i2cbus.write_byte_data (g_ioaddress, IODIRA, 0x00) # Configure port A as output
    i2cbus.write_byte_data (g_ioaddress, IODIRB, 0xFF) # Configure port B as input
    i2cbus.write_byte_data (g_ioaddress, GPPUB,  0xFF) # Activate  port B's internal pull up resistors
    return i2cbus
	
def Get_DI_Channels (i2cbus):
    return i2cbus.read_byte_data(g_ioaddress, GPIOB)

def Set_DI_Channels (i2cbus, value):
    return i2cbus.write_byte_data(g_ioaddress, GPIOA, value)
	
	
# Read values from the digital input port and output the value on the digital output port.
i2cbus = Initialize_MCP23017()
while True:
    value = Get_DI_Channels (i2cbus)
    Set_DI_Channels(i2cbus, value)
    print value
    time.sleep(0.1)

